/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.world.inventory.data;

import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOption;
import fuzs.armorstatues.mixin.accessor.ArmorStandAccessor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;

public enum ArmorStandStyleOptions implements ArmorStandStyleOption
{
    SHOW_NAME("showName", Entity::m_20340_, Entity::m_20151_),
    SHOW_ARMS("showArms", (armorStand, setting) -> ArmorStandStyleOption.setArmorStandData(armorStand, setting, 4), armorStand -> ArmorStandStyleOption.getArmorStandData(armorStand, 4)),
    SMALL("small", (armorStand, setting) -> ArmorStandStyleOption.setArmorStandData(armorStand, setting, 1), armorStand -> ArmorStandStyleOption.getArmorStandData(armorStand, 1)),
    INVISIBLE("invisible", ArmorStand::m_6842_, Entity::m_20145_),
    NO_BASE_PLATE("noBasePlate", (armorStand, setting) -> ArmorStandStyleOption.setArmorStandData(armorStand, setting, 8), armorStand -> ArmorStandStyleOption.getArmorStandData(armorStand, 8)),
    NO_GRAVITY("noGravity", Entity::m_20242_, Entity::m_20068_),
    SEALED("sealed", (armorStand, setting) -> {
        armorStand.m_20331_(setting.booleanValue());
        ((ArmorStandAccessor)armorStand).setDisabledSlots(setting != false ? 0x3F3F3F : 0);
    }, Entity::m_20147_);

    private final String translationId;
    private final BiConsumer<ArmorStand, Boolean> newValue;
    private final Function<ArmorStand, Boolean> currentValue;

    private ArmorStandStyleOptions(String translationId, BiConsumer<ArmorStand, Boolean> newValue, Function<ArmorStand, Boolean> currentValue) {
        this.translationId = translationId;
        this.newValue = newValue;
        this.currentValue = currentValue;
    }

    @Override
    public String getTranslationId() {
        return this.translationId;
    }

    @Override
    public void setOption(ArmorStand armorStand, boolean setting) {
        this.newValue.accept(armorStand, setting);
    }

    @Override
    public boolean getOption(ArmorStand armorStand) {
        return this.currentValue.apply(armorStand);
    }

    @Override
    public void toTag(CompoundTag tag, boolean currentValue) {
        String dataKey = switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SHOW_NAME -> "CustomNameVisible";
            case SHOW_ARMS -> "ShowArms";
            case SMALL -> "Small";
            case INVISIBLE -> "Invisible";
            case NO_BASE_PLATE -> "NoBasePlate";
            case NO_GRAVITY -> "NoGravity";
            case SEALED -> "Invulnerable";
        };
        tag.m_128379_(dataKey, currentValue);
        if (this == SEALED) {
            tag.m_128405_("DisabledSlots", currentValue ? 0x3F3F3F : 0);
        }
    }

    @Override
    public boolean allowChanges(Player player) {
        return this != SEALED || player.m_150110_().f_35937_;
    }
}

